%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
% JAST.cls, v0.0.1, 03/April/2024
% Based on Overleaf's  Template
% Modified by M. S. Qusailah for
% Sana'a University Journal of Applied Sciences and Technology
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
% 
\ProvidesClass{JASTAuthor}[03/04/2024, v0.0.1]
\RequirePackage{ifdraft}
\ifdraft{
  \LoadClass[oneside,onecolumn,12pt]{article}}{
  \LoadClass[twoside,twocolumn,12pt]{article}}
\ifdraft{\RequirePackage[mathlines]{lineno}}{}
\RequirePackage[T1]{fontenc}
\RequirePackage[utf8]{inputenc}
\RequirePackage{microtype}
\RequirePackage{tgheros}
\RequirePackage{amsmath}
\RequirePackage{amssymb}
%\RequirePackage[mathbf,mathcal,text-hat-accent]{euler}
\RequirePackage{cmbright}
% Math font
\renewcommand{\rmdefault}{phv}
\renewcommand{\sfdefault}{phv}
\RequirePackage{relsize}
%\RequirePackage{siunitx}
%\sisetup{
%  separate-uncertainty = true,
%  mode = text
%}
\RequirePackage{ragged2e}
\RequirePackage{xcolor}
\RequirePackage{colortbl}
% \RequirePackage[italic]{mathastext}
\RequirePackage{graphicx}
\RequirePackage{etoolbox,xpatch}
\RequirePackage{environ}
\RequirePackage{lastpage}
\RequirePackage{rotating}
\RequirePackage{lscape}
\RequirePackage{afterpage}
\RequirePackage[absolute]{textpos}
\RequirePackage{url}
\RequirePackage{newfloat}
\RequirePackage{mdframed}
\RequirePackage[explicit]{titlesec}
\RequirePackage{scrextend}
\RequirePackage{lipsum}
% Font definition for the main text
\renewcommand*\familydefault{\sfdefault}
%\fontfamily{qhv}\selectfont
%\renewcommand{\normalfont}{\usefont{T1}{qhv}{n}{m}\selectfont}
\ifdraft{\changefontsizes[19pt]{9.5pt}}{\changefontsizes[13pt]{9.5pt}}
\ifdraft{\renewcommand\linenumberfont{\footnotesize}}{}
\RequirePackage{calc}
\RequirePackage{geometry}
\geometry{includefoot,
%  paperheight=297mm,
%  paperwidth=210mm,
a4paper,
  hmargin=19mm,
  bottom=10mm,
  top=20mm,
  headsep=5.4mm,
  headheight=5.6mm,
  footnotesep=1pc+6pt,
  columnsep=8.5mm}
\setlength{\parindent}{12pt}
\urlstyle{sf}


\newcommand{\verfont}{\normalfont\sffamily\fontsize{10}{11}\selectfont}
\newcommand{\headerfont}{\normalfont\sffamily\fontsize{7}{9}\selectfont}
\renewcommand{\titlefont}{\normalfont\sffamily\bfseries\fontsize{21}{23}\selectfont}
\newcommand{\datesfont}{\normalfont\sffamily\itshape\fontsize{8}{10}\selectfont}
\renewcommand\UrlFont{\color{jcolor1}\sffamily}
\newcommand{\absfont}{\normalfont\rmfamily%\bfseries%
	\linespread{1.2}\fontsize{10}{12}\selectfont}
\newcommand{\copyrightfont}{\normalfont\sffamily\fontsize{8}{10}\selectfont}
\newcommand{\ociscodefont}{\normalfont\sffamily\fontsize{8}{10}\selectfont}

\definecolor{jcolor}{RGB}{5.0,47.0,79.0}
\definecolor{jcolor0}{RGB}{5.0,47.0,79.0}
\definecolor{jcolor1}{RGB}{0.0,91.4,125.0}
\definecolor{jcolor1b}{RGB}{59,90,198} % author email, doi
% color2 defined by the specific journal style file
\definecolor{jcolor2}{RGB}{5.0,47.0,79.0}
\definecolor{jcolor2b}{RGB}{15.0,47.0,79.0}
\definecolor{jcolor3}{RGB}{0.0,91.4,125.0}
\definecolor{jcolor4}{RGB}{22.3,201.6,155.8}
\definecolor{jcolor5}{RGB}{170.5,206.6,224.5}

\ifdraft{
  \renewcommand\thelinenumber{\color{jcolor2}\arabic{linenumber}}
}{}

\RequirePackage[noblocks]{authblk}
\renewcommand\Authfont{\centering}

% Journal name and visual identity
\def\@jname{Sana'a University Journal of Applied Sciences and Technology}
\def\@jurl{https://journals.su.edu.ye/index.php/jast}
\def\@jissn{ISSN 2958-9568}
\def\@jdoi{http://dx.doi.org/10.59628/jast}
\def\@jissnurl{https://portal.issn.org/resource/ISSN/2958-9568}
\def\@jnick{JAST}
\def\@jlogo{JAST.png}
\def\@jEPlogo{JAST2P.png}
\def\@jOPlogo{JAST3P.png}

\def\@cclogo{cc.png}
\newcommand{\jname}[1]{\def\@jname{#1}}
\newcommand{\jurl}[1]{\def\@jurl{#1}}
\newcommand{\jissnurl}[1]{\def\@jissnurl{#1}}
\newcommand{\jissn}[1]{\def\@jissn{#1}}
\newcommand{\jdoi}[1]{\def\@jdoi{#1}}
\newcommand{\jnick}[1]{\def\@jnick{#1}}
\newcommand{\jlogo}[1]{\def\@jlogo{#1}}
\newcommand{\cclogo}[1]{\def\@cclogo{#1}}



% Article bibliographic info ### for editors to fill ###
\def\@jyear{}
\def\@jvolume{}
\def\@jnumber{}
\def\@jissuenumber{}
\def\@jstartpage{}
\def\@jendpage{}
\def\@jpapercat{}
\def\@jspecial{}
\def\@jeditor{}
\def\@jaeditor{}
\def\@jsubmitted{}
\def\@japproved{}
\def\@jrevised{}
\def\@jaccepted{}
\def\@javailableonline{}

\newcommand{\jyear}[1]{\def\@jyear{#1}}
\newcommand{\jvolume}[1]{\def\@jvolume{#1}}
\newcommand{\jnumber}[1]{\def\@jnumber{#1}}
\newcommand{\jissuenumber}[1]{\def\@jissuenumber{#1}}
\newcommand{\jstartpage}[1]{\def\@jstartpage{#1}}
\newcommand{\jendpage}[1]{\def\@jendpage{#1}}
\newcommand{\jpapercat}[1]{\def\@jpapercat{#1}}
\newcommand{\jspecial}[1]{\def\@jspecial{#1}}
\newcommand{\jeditor}[1]{\def\@jeditor{Editor: #1}}
\newcommand{\jaeditor}[1]{\def\@jaeditor{Associate Editor: #1}}
\newcommand{\jsubmitted}[1]{\def\@jsubmitted{#1}}
\newcommand{\jrevised}[1]{\def\@jrevised{#1}}
\newcommand{\jaccepted}[1]{\def\@jaccepted{#1}}
\newcommand{\japproved}[1]{\def\@japproved{#1}}
\newcommand{\javailableonline}[1]{\def\@javailableonline{#1}}


\newcommand{\jjdoi}{\@jdoi.v\@jvolume.i\@jissuenumber}
% These are for the authors to fill
\def\@runningauthor{}
\def\@runningtitle{}
\def\@corraddress{}
\def\@authnotes{}
\def\@corrauths{}
\newcommand{\runningauthor}[1]{\def\@runningauthor{#1}}
\newcommand{\runningtitle}[1]{\def\@runningtitle{#1}}
\newcommand{\corraddress}[1]{\def\@corraddress{#1}}
\newcommand{\authnote}[1]{\appto{\@authnotes}{#1\par}}
\newcommand{\corrauth}[1]{\appto{\@corrauths}{#1\par}}

% article meta data
%
\newcommand{\keywords}[1]{\def\@keywords{#1}}
\newcommand{\articlehistory}[1]{\def\@articlehistory{#1}}
\newcommand{\articlehistoryname}{\bf{Article History:}} % Defines the keywords heading name
\newcommand{\keywordname}{\bf{Keywords:}} % Defines the keywords heading name
\articlehistory{%
	{\bf{Received:}} \@jrevised,
	\par {\bf{Revised:}} \@jrevised,
	\par {\bf{Accepted:}} \@jaccepted,
	\par {\bf{Available online:}} \@javailableonline
	\par     
}
% Headers and footers
% \newcommand{\footfont}{\fontfamily{qhv}\fontsize{7.5pt}{10pt}\selectfont}
\newcommand{\footfont}{\fontfamily{qhv}\footnotesize\selectfont}
\RequirePackage[flushmargin,bottom,norule]{footmisc}
\appto{\footnotelayout}{\footfont}

% Copyright statement
\RequirePackage{textcomp} % For copyright symbol styling
\newcommand{\copyrightstatement}{\;\textcopyright\,\the\year{}~{\href{\@jurl}{\@jnick}}}

\RequirePackage{fancyhdr}
\fancyhf{}
\renewcommand{\footrule}{\color{jcolor1}\rule{\textwidth}{0.2pt}}
\renewcommand{\headrule}{}
% this makes the boxed page numbers
\newcommand\boxpage{
	\raisebox{0.0pt}[0pt][0pt]{
		\color{lightgray}\rule[-0.4ex]{4.5ex}{2.3ex}
		\hspace*{-3.2ex}%%
		\makebox[3pt]{\textcolor{jcolor2}{\thepage}}%%
		\hspace*{1ex}
	}
}

\renewcommand{\headrule}{}
\fancyhead[RO]{%
	\begin{textblock*}{33pc}(25pt,15pt)      
		\includegraphics[height=0.1\linewidth, draft=false]{\@jEPlogo}
	\end{textblock*}
	\fontfamily{qhv}\footnotesize\selectfont%
	\color{jcolor2}%
	\@runningtitle%
	\hspace*{0pt}%
}
\fancyhead[LE]{%
	\begin{textblock*}{33pc}(25pt,15pt)       
		\includegraphics[height=0.1\linewidth, draft=false]{\@jOPlogo}
	\end{textblock*}
	\fontfamily{qhv}\footnotesize\selectfont%
	\color{jcolor2}%
	\@runningauthor%
	\hspace*{00pt}%
}
\fancyfoot[R]{%
	\fontfamily{qhv}\footnotesize\selectfont%
	\color{black}%
	\hspace{1em}\raisebox{0pt}{\qquad\href{\@jurl}{\@jname}		}
	\textbf{\boxpage}%
}
\fancyfoot[L]{%
	\fontfamily{qhv}\footnotesize\selectfont%
	\color{black}%
	\hspace{0em}\raisebox{0pt}{	\copyrightfont\ifthenelse{\boolean{displaycopyright}}{\copyrightstatement}{}
	}
	{\par%
		\fontfamily{qhv}\footnotesize\selectfont
		\color{black}%
		\hspace{0em}\raisebox{0pt}{
			{\fontfamily{qhv}\verfont\selectfont%
				\color{black}{\,Vol.\@jvolume,\;No.\@jnumber,\;Page\,\@jstartpage-\,\@jendpage,\;\@jyear}}
	}}
}


\fancypagestyle{nofancy}{%
	\fancyhf{}
}
\fancypagestyle{plain}{%
	\fancyhf{}
	\renewcommand{\headrule}{}
	% footer for the 1st page
	\fancyfoot[R]{%
		\fontfamily{qhv}\footnotesize\selectfont%
		\color{black}%
		\hspace{1em}\raisebox{0pt}{\qquad\href{\@jurl}{\@jname}		}
		\textbf{\boxpage}%
	}
	\fancyfoot[L]{%
		\fontfamily{qhv}\footnotesize\selectfont%
		\color{black}%
		\hspace{0em}\raisebox{0pt}{	\copyrightfont\ifthenelse{\boolean{displaycopyright}}{\copyrightstatement}{}
		}
	}
}

\ifdraft{\pagestyle{nofancy}}{\pagestyle{fancy}}

%%% Makes orcid links for authors
%%%-------- Note: this was copied from package orcidlink.sty ----------
\RequirePackage{tikz}
\ProcessOptions\relax
\usetikzlibrary{svg.path}
\definecolor{orcidlogocol}{HTML}{A6CE39}
\tikzset{
  orcidlogo/.pic={
    \fill[orcidlogocol] svg{M256,128c0,70.7-57.3,128-128,128C57.3,256,0,198.7,0,128C0,57.3,57.3,0,128,0C198.7,0,256,57.3,256,128z};
    \fill[white] svg{M86.3,186.2H70.9V79.1h15.4v48.4V186.2z}
                 svg{M108.9,79.1h41.6c39.6,0,57,28.3,57,53.6c0,27.5-21.5,53.6-56.8,53.6h-41.8V79.1z M124.3,172.4h24.5c34.9,0,42.9-26.5,42.9-39.7c0-21.5-13.7-39.7-43.7-39.7h-23.7V172.4z}
                 svg{M88.7,56.8c0,5.5-4.5,10.1-10.1,10.1c-5.6,0-10.1-4.6-10.1-10.1c0-5.6,4.5-10.1,10.1-10.1C84.2,46.7,88.7,51.3,88.7,56.8z};
  }
}
\newcommand{\@OrigHeightRecip}{0.003}
\newlength{\@curXheight}
\DeclareRobustCommand\orcidlink[1]{%
\texorpdfstring{%
\setlength{\@curXheight}{\fontcharht\font`X}%
\href{https://orcid.org/#1}{\XeTeXLinkBox{\mbox{%
\begin{tikzpicture}[baseline={(0,-0.45)}, yscale=-\@OrigHeightRecip*\@curXheight,
xscale=\@OrigHeightRecip*\@curXheight,transform shape]
\pic{orcidlogo};
\end{tikzpicture}%
}}}}{}}
%%%-------------------------------------------------------


% This is related to the corresponding authors
\RequirePackage{alphalph}
\newalphalph{\fnsymbolmult}[mult]{\@fnsymbol}{5}
\newcounter{caut}
\setcounter{caut}{1}
\newcommand{\cauthfn}[1]{\fnsymbolmult{#1}}

% This is related to the authors and affiliation lists
\renewcommand\Authands{ and }
\renewcommand\AB@affilsepx{,\par}
%\renewcommand{\Affilfont}{\fontfamily{qhv}\fontsize{8.5pt}{11pt}\selectfont}
\renewcommand{\Affilfont}{\footnotesize\raggedright}
\setlength{\affilsep}{21pt-9pt}


\newcommand{\gscitedetails}{%
	\parbox{\textwidth-00.0mm}{\href{\jjdoi}{\jjdoi}
		~~\href{\@jissnurl}{\@jissn}
		~\qquad~{\href{\@jurl}{\@jnick}}}}
	
\AtBeginDocument{
	\renewcommand{\@maketitle}{%
		\textblockorigin{10mm}{7.0mm}
		\ifdraft{}%
		{%
		\begin{textblock*}{33pc}(-2pt,15pt)      
				\includegraphics[height=0.1\linewidth, draft=false]{\@jEPlogo}
		\end{textblock*}
		\begin{textblock*}{0.85\textwidth}(10.0mm,30pt)
			\fontfamily{qhv}\verfont\selectfont%
			\color{black}%
			\hspace{0em}\raisebox{0pt}{\qquad\href{\@jurl}{\@jname}		}
		\end{textblock*}
		\begin{textblock*}{0.85\textwidth}(70.0mm,-10pt)
			\gscitedetails
		\end{textblock*}
		{\begin{textblock*}{0.5\textwidth}(1.5mm,-10pt)
				{\fontfamily{qhv}\verfont\selectfont%
					\color{black}{\, Vol.\@jvolume,\;No.\@jnumber,\;Page\,\@jstartpage-\,\@jendpage,\;\@jyear}}
		\end{textblock*}}
		}
		\,\vspace{20mm}
		\setlength{\affilsep}{5.5mm}
		\begin{center}
			\linespread{0.75}
			{\fontfamily{qhv}%
				\fontsize{20pt}{27pt}\mdseries\bfseries
				%\sffamily\bfseries\fontsize{20}{25}
				\selectfont\@title\par}
			\vspace{3.3mm}
			{\fontfamily{qhv}%
				\fontsize{14pt}{14pt}\mdseries\bfseries
				%\sffamily\bfseries\fontsize{20}{25}
				\selectfont \@author\par}      
		\end{center}
		\ifdraft{
			\renewcommand{\cauthfn}[1]{\protect{\normalcolor\textsuperscript{\fnsymbolmult{##1}}Corresponding author:}}}{
			\renewcommand{\cauthfn}[1]{\protect{\normalcolor\textsuperscript{\fnsymbolmult{##1}}Corresponding author:}}
		}    
		{\fontfamily{qhv}\footnotesize\selectfont{\textcolor{jcolor1}\@corrauths}\normalcolor\par}%
		\vspace{2.58mm}
	}
}


\RequirePackage[style]{abstract}
\setlength{\absleftindent}{0pt}
\setlength{\absrightindent}{0pt}
\setlength{\absparindent}{12pt}
\setlength{\absparsep}{0pt}
\setlength{\abstitleskip}{16pt-8pt-\baselineskip}
\renewcommand{\abstractnamefont}{\usefont{T1}{qhv}{b}{sc}\fontsize{14pt}{16.5pt}\selectfont\color{jcolor}}
\renewcommand{\abstitlestyle}[1]{{\abstractnamefont #1}}

\ifdraft{
  \renewcommand{\abstracttextfont}{\fontfamily{qhv}\fontsize{9.5pt}{20pt}\selectfont}
}{
  \renewcommand{\abstracttextfont}{\usefont{T1}{qhv}{}{}\fontsize{10.0pt}{12pt}\selectfont}
}
\preto{\abstract}{%
  {\noindent\rule{\hsize}{0.2pt}}\par
   \vspace*{2.5mm}
}
\appto\abstract{\noindent\justifying\ignorespaces 
  \ifdraft{\linenumbers}{}}
\preto\endabstract{\par}

%-----------------------------------------------------------------------------
  \ifdraft{
  \NewEnviron{frontmatter}{%   
    \BODY%
    \vspace*{\dimexpr 16pt-3pt-1em\relax}
        {\noindent\rule{\hsize}{0.2pt}}\par
    \vspace*{\dimexpr 23pt-1em\relax}%
    {{Keywords}\normalcolor}:\par\@keywords\par%
   	{\noindent\rule{\hsize}{0.2pt}}\par
	\vspace{-3.5mm}
	{\noindent\rule{\hsize}{0.2pt}}\par
	\vspace{3.0mm}
  }
}{
  \NewEnviron{frontmatter}
  {\twocolumn[%
    \BODY
    % space after abstract 
    \vspace*{-4mm}
    % this is the rule below the abstract
    {\noindent\rule{\hsize}{0.2pt}}\par
\parbox{\dimexpr\linewidth-0\fboxsep\relax}{\usefont{T1}{qhv}{b}{sc}\fontsize{14pt}{16.5pt}\selectfont\color{jcolor}{Article Info}}\par%
    \begin{minipage}{0.05\textwidth}
    		\noindent\;
    \end{minipage}
    \begin{minipage}{0.40\textwidth}
    		\parbox{\dimexpr\linewidth-2\fboxsep\relax}{%
    			{\color{jcolor1}\keywordname\hspace*{2em}}\par\@keywords%
    		}%
    \end{minipage}
    \begin{minipage}{0.05\textwidth}
    		\noindent\;
    \end{minipage}
    \begin{minipage}{0.40\textwidth}
    		\parbox{\dimexpr\linewidth-0\fboxsep\relax}{{\color{jcolor1}\articlehistoryname\hspace*{20em}}{\par\@articlehistory}}
    		\vspace{2.0mm}
    \end{minipage}
\par
	\vspace*{\dimexpr 22pt-8pt-\baselineskip\relax}%
	{\noindent\rule{\hsize}{0.2pt}}\par
	\vspace{-4.00mm}
	{\noindent\rule{\hsize}{0.2pt}}\par
	\vspace{3.0mm}
    ]
  }
}
%\setcounter{secnumdepth}{0}


\titleformat{\section}{\usefont{T1}{qhv}{b}{sc}\fontsize{12}{10}\selectfont\color{jcolor2}}
{\thesection.}
{0.5em}
{\MakeUppercase{#1}}
[]
\titlespacing*{\section}{0pt}{26.5pt-1em}{16pt-1em}
%

\titleformat{\subsection}{\usefont{T1}{qhv}{b}{sc}\fontsize{12pt}{14pt}\selectfont\color{jcolor}}{\thesubsection.}{0.5em}{#1}
\titlespacing*{\subsection}{0pt}{2pc-1em}{17pt-1em}
%
\titleformat{\subsubsection}{\usefont{T1}{qhv}{b}{it}\selectfont}{\thesubsubsection.}{0.5em}{#1}
\titlespacing*{\subsubsection}{1pt}{\baselineskip}{0pt}
%
\titleformat{\paragraph}[runin]{\normalsize\itshape}{\theparagraph}{0pt}{#1}[.\enspace]
\titlespacing{\paragraph}{0pt}{\baselineskip}{0pt}
%
\titleformat{\subparagraph}[runin]{\relsize{-1}\uppercase}{\thesubparagraph}{0pt}{#1}[.\enspace]
\titlespacing*{\subparagraph}{0pt}{\baselineskip}{0pt}


\RequirePackage{enumitem}
\setlist{noitemsep}
\setlist[itemize]{leftmargin=13pt,topsep=16pt-1em}
\setlist[enumerate]
{itemindent=17pt,topsep=16.8pt-1em,
  label={\roman*.},labelsep=7pt,
  labelwidth=*,leftmargin=8pt,align=right}
\setlist[description]{itemindent=-17pt,labelsep=7pt,topsep=16pt-1em}

\ifdraft{\linenumbers}{}

% quotes and epigraphs
\RequirePackage{quoting}
\newcommand{\quotefont}{\fontfamily{qhv}\fontsize{8.5pt}{10pt}\selectfont}
\quotingsetup{vskip=16pt-1em,indentfirst=false,font={quotefont},leftmargin=4mm,rightmargin=4mm}

\renewenvironment{quote}{\begin{quoting}}{\end{quoting}}
\renewenvironment{quotation}{\begin{quoting}}{\end{quoting}}
\newenvironment{epigraph}[1]
{\begin{quoting}[font={itshape,fontsize{8.5pt}{10pt}},vskip=15pt-1em,leftmargin=2mm,rightmargin=2mm]%
    \def\@quotesource{#1}}
  {\par\vspace{\dimexpr 15pt-1em\relax}{\upshape---\@quotesource}\end{quoting}}

% Space above/below equations
\g@addto@macro\normalsize{%
  \setlength\abovedisplayskip{0.5\baselineskip}%
  \setlength\belowdisplayskip{0.5\baselineskip}%
  \setlength\abovedisplayshortskip{0.25\baselineskip}%
  \setlength\belowdisplayshortskip{0.25\baselineskip}%
}

\RequirePackage{stfloats}
\RequirePackage{booktabs}
\RequirePackage{tabularx}
% Left-, right- and center-aligned auto-wrapping column types
\newcolumntype{L}{>{\raggedright\arraybackslash}X}
\newcolumntype{R}{>{\raggedleft\arraybackslash}X}
\newcolumntype{C}{>{\centering\arraybackslash}X}

\AtBeginEnvironment{tabularx}{%
  \fontfamily{qhv}\fontsize{8.5pt}{10pt}\selectfont
}
\AtBeginEnvironment{tabular}{%
  \fontfamily{qhv}\fontsize{8.5pt}{10pt}\selectfont
}

\setlength{\aboverulesep}{11pt-1em}
\setlength{\belowrulesep}{11pt-1em}
\setlength{\heavyrulewidth}{0.5pt}
\setlength{\lightrulewidth}{0.5pt}
\arrayrulecolor{jcolor}


\newcommand{\tnote}[1]{\textsuperscript{\textit{#1}}}
\newlist{tablenotes}{itemize}{1}
\setlist[tablenotes]{label={},labelsep=0pt,leftmargin=0pt,topsep={\dimexpr 12pt-1em\relax}}
\appto{\tablenotes}{\fontfamily{qhv}\fontsize{6.5pt}{8pt}\selectfont}


\RequirePackage[tableposition=top]{caption}
\DeclareCaptionFont{figcaptionfont}{\small}
\DeclareCaptionFont{tabcaptionfont}{\small}
\captionsetup{justification=justified,singlelinecheck=false,labelfont={bf},labelsep=period}
\captionsetup*[figure]{font=figcaptionfont,skip=10pt}
\captionsetup*[table]{font=tabcaptionfont,skip=10pt-1em}

% Skips for floats
\setlength{\floatsep}{1pc+6pt}
\setlength{\intextsep}{1pc+6pt}
\setlength{\textfloatsep}{1pc+6pt}


\makeatletter
\newenvironment{tablehere}
  {\captionsetup{type=table}}{}
\newenvironment{figurehere}
  {\captionsetup{type=figure}}{}
\newenvironment{tablehere*}
  {\captionsetup{type=table*}}{} 
\newenvironment{figurehere*}
  {\captionsetup{type=figure*}}{}
\makeatother 

\RequirePackage[colorlinks=true,allcolors=blue,urlcolor=jcolor,draft=false]{hyperref}

% Journal type
\newcommand*{\journal}[1]{%
	\RequirePackage{JAST-styles/#1}%   Corresponding style file
	\def\journalref{#1}}% Set a reference for the journal


\RequirePackage[numbers,sort&compress]{natbib}
\setlength{\bibsep}{0.0pt}
% bibliography style defined by the specific journal style file

\def\bibfont{\normalfont\sffamily\fontsize{8}{10}\selectfont}
\newlength{\biblabelwidth}
\settowidth{\biblabelwidth}{\bibfont 00. }
% \makeatletter
%\renewcommand\@biblabel[1]{\makebox[\biblabelwidth][l]{#1.}} % Remove brackets from label
\def\tagform@#1{\maketag@@@{\bfseries(\ignorespaces#1\unskip\@@italiccorr)}}
\renewcommand{\eqref}[1]{\textup{{\normalfont Eq.~(\ref{#1}}\normalfont)}}
% \makeatother

%% Automatically abbreviate journal titles
\RequirePackage{jabbrv}
%\renewcommand{\bibliographyfullrefs}[1]{}
\RequirePackage[resetlabels]{multibib}
%\newcites{fullrefs}{Full References}  %% Or whatever the heading might be
%\bibliographystylefullrefs{Jastjnl}    %% The full style

%\citationmode{abbr}
%%%%%%%%%%%%%
%% LLT: Providing the list of full refs
% Creating a new bibliography
\RequirePackage[resetlabels]{multibib}
\newcites{fullrefs}{Full References}  %% Or whatever the heading might be
%\bibliographystyle{Jastjnl}    %% The full style

% Patching \cite to automatically add cite
% to fullrefs list
\RequirePackage{letltxmacro}
\RequirePackage{xparse}
\LetLtxMacro\oldcite\cite
\RenewDocumentCommand{\cite}{O{} O{} m}{\oldcite[#1][#2]{#3}\nocitefullrefs{#3}}
\LetLtxMacro\oldcitep\citep
\RenewDocumentCommand{\citep}{O{} O{} m}{\oldcitep[#1][#2]{#3}\nocitefullrefs{#3}}
\LetLtxMacro\oldcitet\citet
\RenewDocumentCommand{\citet}{O{} O{} m}{\oldcitet[#1][#2]{#3}\nocitefullrefs{#3}}

% Silence the "citation multiply defined" warning
\RequirePackage{silence}
\WarningFilter{natbib}{Citation `}
\WarningFilter{natbib}{There were multiply}
\WarningFilter{caption}{Unused \captionsetup}

% Delay certain patches/options till \begin{document} when all the booleans are set
\RequirePackage{xpatch}
%% Change pagestyle to fancy after \maketitle
\apptocmd{\maketitle}
{\thispagestyle{plain}}
{\typeout{Banner added to title page.}}%
{\ClassWarning{optica}{Could not change title page style.}}
	
\AtBeginDocument{%
\colorlet{jcolor2}{jcolor2b}
\pretocmd{\bibliographyfullrefs}{\clearpage}{}
{\renewcommand{\bibliographyfullrefs}[1]{}}
}
	
\bibliographystyle{JASTjnl}

\RequirePackage{amsmath}
\RequirePackage{amsfonts}
\RequirePackage{amssymb}
\RequirePackage{mathpazo} % Widely available alternative to Garamond

\renewcommand{\eqref}[1]{\textup{{\normalfont Eq.~(\ref{#1}}\normalfont)}}

\newcommand{\onlyonecolumn}[1]{%
		\ifdraft{%
		\onecolumn{#1}}{%
		\onecolumn{#1}%
		\twocolumn}
		}

\usepackage{float}
\usepackage[export]{adjustbox}
\usepackage{subcaption}
\makeatletter
%---------------------------------------------------------
\newboolean{displaycopyright}
\setboolean{displaycopyright}{true}

%%%